VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Create Trial Application Sample"
   ClientHeight    =   2070
   ClientLeft      =   5700
   ClientTop       =   3105
   ClientWidth     =   3900
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2070
   ScaleWidth      =   3900
   Begin VB.CommandButton cmdRegister 
      Caption         =   "Display Registration Form"
      Height          =   750
      Left            =   1170
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   " Show a sample registration screen "
      Top             =   1185
      Width           =   1590
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Your Application's Form"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   855
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   3615
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' Copyright  2002 David Scarmozzino
'      All Rights Reserved
' http://www.TheScarms.com/AppSentinel
'         TheScarms (TM)
'
' This source code may not be redistributed. Redistributing
' this source code is a violation of copyright laws.
'
' This sample program was designed to serve as an example
' of calling the various methods of the AppSentinel DLLs.
'
' It is not intended to be used "as is" in your production
' application. The actual logic and sequence of DLL method
' calls must be designed to suit your specific needs.

' Return values from the fRegister routine.
Private Const cregRegistered = 0
Private Const cregEvaluating = 1
Private Const cregExpired = 2
Private Const cregError = -99
Private Function fRegister(ByRef strError As String) As Long

    '
    '---------------------------------------------------------------------
    ' Check the registration status of your application.
    '
    ' Return:
    '   cregRegistered - Properly Registered.
    '   cregEvaluating - Not registered. Evaluation period not expired.
    '   cregExpired    - Not registered. Evaluation period expired.
    '   cregError      - Error occured.
    '
    '   strError       - Contains the error message on error.
    '---------------------------------------------------------------------
    '
    strError = ""
    fRegister = cregExpired
    On Error GoTo ErrorHandler

    ' Read/check registration information.
    If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
    If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
    
    ' See if application is registered.
    If gobjAppSentinel.Registered Then
        fRegister = cregRegistered
        Exit Function
    End If
    
    If gobjAppSentinel.Expired Then
        ' Trial period has expired.
        fRegister = cregExpired
        
        ' Show registration form and recheck
        ' registration in case user just registered.
        frmRegister.Show vbModal
        If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
        If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
        If gobjAppSentinel.Registered Then fRegister = cregRegistered
    Else
        'Still within trial period.
        fRegister = cregEvaluating
    End If
    Exit Function
    
ErrorHandler:
    ' A method of AppSentinel returned false. Assume
    ' your application is not registered or expired.
    fRegister = cregError
    If strError = "" Then strError = Err.Description
End Function
Private Sub cmdRegister_Click()

    ' Show the registration screen.
    frmRegister.Show vbModal

End Sub
Private Sub Form_Load()
Dim lngResult As Long
Dim strTemp   As String
Dim strError  As String
    
    ' Only allow one instance of your app. Center the form.
    If App.PrevInstance Then End
    Me.Left = (Screen.Width - Me.Width) / 2
    Me.Top = ((Screen.Height - Me.Height) / 2)
    
    ' IMPORTANT:
    ' READ ObjectBinding.htm BEFORE RUNNING/CHANGING THIS CODE.
    'Set gobjAppSentinel = CreateObject("SEN10L.Registration")
    Set gobjAppSentinel = CreateObject("SEN10LT.Registration")
    '
    ' Set your evaluation period and required parameters.
    '
    ' Parameter       Description
    ' --------------  -------------------------------------------------
    ' FileMask        Required. Suggested length - 10 characters.
    '                 Used to create the names of the files which
    '                 store your application's registration data.
    '                 Mask should be unique. If AppSentinel is used in
    '                 more than one of your applications, use a
    '                 different mask in each application.
    '
    ' RegistrySubkey  Required. Typically: YourCompanyName\YourAppName
    '
    ' TrialDays*      Optional. The number of days to allow in your
    '                 evaluation period.
    ' TrialRuns*      Optional. The number of times your application
    '                 can be used during your evaluation period.
    '
    ' * TrialDays or TrialRuns or both must be set.
    '
    gobjAppSentinel.TrialDays = 20
    gobjAppSentinel.TrialRuns = 50
    gobjAppSentinel.RememberMID = False
    gobjAppSentinel.UseMACAddress = False
    gobjAppSentinel.FileMask = "YourFileMask2"
    gobjAppSentinel.RegistrySubkey = cSubKey
    
    ' Check the registration information.
    lngResult = fRegister(strError)
    
    Select Case lngResult
        Case cregRegistered
            ' App is registered. You may want to enable certain
            ' features, hide your registration screen,....
            '
            'Call pDoRegisteredStuff()
        Case cregEvaluating
            ' Trial period has time and/or runs left.
            ' You can tell the user and tell them how to register.
            If gobjAppSentinel.DaysLeft <> "" Then
                strTemp = "You have " & gobjAppSentinel.DaysLeft & " day(s) remaining."
            End If
            If gobjAppSentinel.RunsLeft <> "" Then
                If strTemp <> "" Then strTemp = strTemp & vbCrLf
                strTemp = "You have " & gobjAppSentinel.RunsLeft & " run(s) remaining."
            End If
            Call MsgBox(strTemp, vbInformation, "Evaluation Version")
            
            ' You may want to show your nag screen, disable features,...
            'Call pDoEvaluationStuff()
        Case cregExpired
            ' Trial period expired.
            Call MsgBox("Your evaluation period has expired.", vbCritical, "Evaluation Period Expired")
            ' This sample has logic in fRegister to redisplay the
            ' registration form giving the user a chance to register.
            '
            ' NOTE:
            ' If you terminate your app using the END statement, you MUST
            ' Set gobjAppSentinel = Nothing first. See ObjectBinding.htm.
            Call MsgBox("This application will shut down.", vbCritical, "Evaluation Period Expired")
            Set gobjAppSentinel = Nothing
            Unload Me
        Case cregError
            ' Something went wrong. Tell the user.
            Call MsgBox(strError, vbCritical, "Error Verifying Registration")
            ' Assume the app is not registered and end your program.
            Set gobjAppSentinel = Nothing
            Unload Me
            ' If strError is an 'Internal Error', report the problem to
            ' Sales@TheScarms.com providing as much detail as possible.
    End Select

    ' Your normal Form_Load code goes here.
End Sub
Private Sub Form_Unload(Cancel As Integer)

    ' You MUST do this.
    Set gobjAppSentinel = Nothing
    
    Set frmMain = Nothing
End Sub


